import pybedtools

filename = "enhancers.bed"
print("Reading", filename)
enhancers = pybedtools.BedTool(filename)
filename = "enhancers.windowed.bed"
print("Writing", filename)
stream = open(filename, "wt")
for enhancer in enhancers:
    chrom = enhancer.chrom
    start = enhancer.start
    end = enhancer.end
    assert end - start == 401
    name = enhancer.name
    fields = [chrom, start, start+200, name, "0", "-"]
    enhancer = pybedtools.create_interval_from_list(fields)
    stream.write(str(enhancer))
    fields = [chrom, start+201, end, name, "0", "+"]
    enhancer = pybedtools.create_interval_from_list(fields)
    stream.write(str(enhancer))
stream.close()
